﻿var dbdLang = document.getElementsByTagName('html')[0].lang;
var lsTimeoutCount;
var lsTimeout;
var iframe;
var dbdYear;
var currentDate;
var monthNames;
var btn;

// The BlueLetterBible ScriptTagger will go through the entire calendar searching for,
// and tagging, Bible references - and this takes time!  So we disable that here
// and invoke it ourselves when we view each page
// Unfortunately, this may stop working if BLB change this area of ScriptTagger
if (typeof BLB != "undefined") {  // BLB will be undefined if offline
  if (window.removeEventListener) 
    window.removeEventListener ('load', BLB.Tagger.pageInit,false);
  if (window.detachEvent)
    window.detachEvent ('onload', BLB.Tagger.pageInit); 
}
  
function calInit() {
  var mod = 'modernizr';
  try {
      localStorage.setItem(mod, mod);
      localStorage.removeItem(mod);
  } catch(e) {
          document.write(msg_localStorage);
  }
  iframe=document.getElementById('lsInitFrame');
  if (window.addEventListener) 
    iframe.addEventListener('load', lsInit, false);
  if (window.attachEvent)
    iframe.attachEvent('load', lsInit);
  
  // retrieve language specific DOM elements set in lang.js
  document.title=title;
  document.getElementById('navcrumb').innerHTML=navcrumb;
  document.getElementById('previous').innerHTML=previous;
  document.getElementById('next').innerHTML=next;
  document.getElementById('commentaryHdr').innerHTML=commentaryHdr;
  document.getElementById('toTop').innerHTML=toTop;
  for (var i=0; i<5; i++) {
    document.getElementById('theYear').options[i].innerHTML=theYear[i];
  }
   
  $(function() {
      $('#pickDate').datepicker({
        dateFormat: "yy-mm-dd",
        altField: "#trigger",
        altFormat: "d MM",
      onSelect: function(dateText, inst) {
        $(this).datepicker('hide');
        var oldYear=currentDate.getFullYear();
        currentDate=$(this).datepicker('getDate')
        var newYear=currentDate.getFullYear();
        if (oldYear == newYear && dbdLang == localStorage.getItem('dbdLang')) {
          showcal(currentDate);
        } else {
          var year = (parseInt(dbdYear) + newYear - oldYear) % 5;
          loadYear(year==0 ? "5" : Math.abs(year).toString());
        }
      }
    });
  });
  $('#pickDate').datepicker('setDate',new Date());
  monthNames = $('#pickDate').datepicker( 'option', 'monthNames' );
  if (location.search) {
    currentDate = new Date(decodeURI(location.search.substring(1)));
  } else {
    currentDate = new Date();
  }
  
// do we already have the year set?  are we changing language?
  dbdYear=localStorage.getItem('dbdYear');
  if (dbdYear==null) {
    dbdYear="1";
  } 
  document.getElementById('theYear').value=dbdYear;
  if (dbdYear == localStorage.getItem('dbdYear') && dbdLang == localStorage.getItem('dbdLang')) {
    showcal(currentDate);
  } else {
    loadYear(dbdYear);
  }
}

function btnPress(evt) {
  btn = (evt.target) ? evt.target : evt.srcElement;
  var adjustment = (btn.id=="next") ? +1 : -1;
  btn.blur();
  btn="";
  var oldYear=currentDate.getFullYear();
  currentDate.setDate(currentDate.getDate() + adjustment);
  var newYear=currentDate.getFullYear();
  $('#pickDate').datepicker('setDate', currentDate);
  
  if (oldYear == newYear && dbdLang == localStorage.getItem('dbdLang')) {
    showcal(currentDate);
  } else {
    var year = (parseInt(dbdYear) + newYear - oldYear) % 5;
    loadYear(year==0 ? "5" : Math.abs(year).toString());
  }
}

function loadYear(year) {
  document.body.style.cursor='progress';
  localStorage.removeItem('dbdYear');
  dbdYear=year;
  document.getElementById('theYear').value=dbdYear;
  iframe.contentDocument.location.href='localStorageYear' + dbdYear + '.html';
  lsTimeoutCount=0;
  if (showcal(currentDate) == false) { // if we've just loaded the calendar
    lsTimeout=setInterval(function(){showcal(currentDate)},1000); // it may take a few seconds
  }
}

function lsInit(){
  lsItems = iframe.contentDocument.getElementsByTagName('DIV');
  for (var i=0; i<lsItems.length; i++) {
    var id=lsItems[i].id;
    // exclude the year so, when changing years, we just overwrite
    id=id.substring(0,1)+id.substring(2); 
    localStorage.setItem(id, lsItems[i].innerHTML);
  }
  dbdYear=lsItems[0].id.substring(1,2);
  localStorage.setItem('dbdYear', dbdYear);
  localStorage.setItem('dbdLang', dbdLang);
}

function showcal(caldate) {
  if (localStorage.getItem('dbdYear')!=dbdYear) {
    lsTimeoutCount++;
    if (lsTimeoutCount <= 20) return false;
  }
  clearInterval(lsTimeout);
  if (lsTimeoutCount > 20) {
    alert(msg_timeout);
    return false;
  }
  var mm=caldate.getMonth();
  var dd=caldate.getDate();
  if (dd==29 && mm==1) {dd=28};
  var mon=(mm + 1).toString();
  if (mon.length == 1) {
    mon="0" + mon;
  }
  var day=dd.toString();
  if (day.length == 1) {
    day="0" + day;
  }
  document.getElementById('trigger').textContent=dd.toString() + ' ' + monthNames[mm];

// replace any in-stream pragraph marks with a line break, then just remove any others
  var re=/([^>])(<span class="v">\d+<\/span>)¶ /g;
  var scriptureText=localStorage.getItem('S' + mon + day).replace(re, "$1<br />$2");
  scriptureText=scriptureText.replace(/¶ /g, "");
  
  document.getElementById('scriptureRef').innerHTML=localStorage.getItem('R' + mon + day);
  document.getElementById('scriptureText').innerHTML=scriptureText;
  document.getElementById('commentary').innerHTML=localStorage.getItem('C' + mon + day);

// now invoke the BLB ref tagger for this page
// they don't document this, so it could suddenly stop working
  if (typeof BLB != "undefined") {  // BLB will be undefined if offline or not English
    BLB.Tagger.Translation = 'DBY';
    Dom = YAHOO.util.Dom;
    BLB.Tagger.walkDomTree(document.getElementById('commentary'));
  }
  document.body.style.cursor='default';
}

